#ifndef _EVENTS_CPP
#define _EVENTS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define WIN32_LEAN_AND_MEAN
#define _WIN32_WINNT 0x0500

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WinSock2.H>
#include <WinSock.H>
#include <Stdio.H>
#include <Stdlib.H>

#include "CSockSrvr.H"

#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/HandShake.H"
#include "../Source/Command.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client thread is started.
*/
void CSockSrvr::SubClass_Events::OnBeginClientThread(CSockSrvr *lpCSockSrvr, int iClient)
{
	CCI.bIsAuthenticated = false;
	CCI.bIsEncryptionInit = false;
	CCI.bGotImportTable = false;
	CCI.bCustDBConnected = false;
	CCI.bUseCompression = false;

	memset(&CCI.cNASCCL, 0, sizeof(CCI.cNASCCL));

	WriteLog(lpCSockSrvr->icClientID[iClient], "Initializing Cryptography Set...");
	if(CCI.cNASCCL.InitializeCryptographySet(gsAuthKey, strlen(gsAuthKey), CRYPTFLAGS))
	{
		CCI.bIsEncryptionInit = true;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client thread is being terminated.

	This function is called before any client variables are freed.
*/
void CSockSrvr::SubClass_Events::OnEndClientThread(CSockSrvr *lpCSockSrvr, int iClient)
{
	if(CCI.bCustDBConnected)
	{
		CCI.cCustSQL.Disconnect();
	}

	if(CCI.bIsEncryptionInit)
	{
		WriteLog(lpCSockSrvr->icClientID[iClient], "Uninitializing Cryptography Set...");
		CCI.cNASCCL.UninitializeCryptographySet();
		CCI.bIsEncryptionInit = false;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client is connected.

	Return true to accept the connection, else return false.	
*/
bool CSockSrvr::SubClass_Events::OnConnect(CSockSrvr *lpCSockSrvr, int iClient)
{

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client is accepted.

	Return true to accept the connection, else return false.	
*/
bool CSockSrvr::SubClass_Events::OnAccept(CSockSrvr *lpCSockSrvr, int iClient)
{
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client is connected / accepted.

	Return true to accept the connection, else return false.	
*/
bool CSockSrvr::SubClass_Events::OnAcceptConnect(CSockSrvr *lpCSockSrvr, int iClient)
{
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when a client is being disconnected.

	This function is called before any client variables are freed.
*/
void CSockSrvr::SubClass_Events::OnDisconnect(CSockSrvr *lpCSockSrvr, int iClient)
{
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when data is being sent.

	Return true to send the data, else return false.	
*/

bool CSockSrvr::SubClass_Events::OnSend(CSockSrvr *lpCSockSrvr, int iClient, char *sData, int iSize)
{
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when data is being received.

	Return true to receive the data, else return false.	
*/

bool CSockSrvr::SubClass_Events::OnRecv(CSockSrvr *lpCSockSrvr, int iClient, char *sData, int iSize)
{
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when the client / server is being started.

	Return true to start the client / server, else return false.	
*/
bool CSockSrvr::SubClass_Events::OnStart(CSockSrvr *lpCSockSrvr, int iListenPort)
{

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	Called when the client / server is being stopped.

	Return true to start the client / server, else return false.	
*/
bool CSockSrvr::SubClass_Events::OnStop(CSockSrvr *lpCSockSrvr)
{
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
